#
# -*- Perl -*-
# $Id:$
# Copyright (C) 2004 Tadamasa Teranishi All rights reserved.
#               2004 Namazu Project All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either versions 2, or (at your option)
#  any later version.
# 
#  This program is distributed in the hope that it will be useful
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA
#
#  This file must be encoded in EUC-JP encoding
#

package clearddts;
use strict;
require 'util.pl';
require 'gfilter.pl';

sub mediatype() {
    return ('application/x-clearddts');
}

sub status() {
    return 'yes';
}

sub recursive() {
    return 0;
}

sub pre_codeconv() {
    return 0;
}

sub post_codeconv () {
    return 0;
}

sub add_magic ($) {
    my ($magic) = @_;

    $magic->addMagicEntry('0    string          Start:          application/x-clearddts');

    return;
}

sub filter ($$$$$) {
    my ($orig_cfile, $cont, $weighted_str, $headings, $fields)
      = @_;
    my $cfile = defined $orig_cfile ? $$orig_cfile : '';

    util::vprint("Processing clearDDTS file ...\n");

    my $fh = util::efopen("$cfile");
    my $size = util::filesize($fh);
    if ($size > $conf::FILE_SIZE_MAX) {
	return 'too_large_clearddts_file';
    }
    $$cont = util::readfile($fh);
    util::fclose($fh);

    clearDDTS_filter($cont, $weighted_str, $fields, $headings);

    gfilter::line_adjust_filter($cont);
    gfilter::line_adjust_filter($weighted_str);
    gfilter::white_space_adjust_filter($cont);
    gfilter::show_filter_debug_info($cont, $weighted_str,
			   $fields, $headings);

    return undef;
}

sub clearDDTS_filter ($$$$) {
    my ($contref, $weighted_str, $fields, $headings) = @_;

    clearddts::get_title($contref, $weighted_str, $fields);
    clearddts::get_author($contref, $fields);
    clearddts::get_summary($contref, $fields);

    $$contref =~ s/^[A-Z\-]*?:\s//mgi;

    return;
}

sub get_title ($$$) {
    my ($contref, $weighted_str, $fields) = @_;

    if ($$contref =~ /^Headline:\s(.*)$/m) {
	my $tmp = $1;
	$fields->{'title'} = $tmp;
	my $weight = $conf::Weight{'html'}->{'title'};
	$$weighted_str .= "\x7f$weight\x7f$tmp\x7f/$weight\x7f\n";
    }
}

sub get_author ($$) {
    my ($contref, $fields) = @_;

    if ($$contref =~ /^Updated-by:\s(.*)$/m) {
	my $tmp = $1;
	$fields->{'author'} = $tmp;
    }
}

sub get_summary ($$) {
    my ($contref, $fields) = @_;
    my $summary = '';
    my $mode = 0;
    my @cont = split(/\n/, $$contref);

    foreach my $line (@cont) {
        if ($line =~ /^Related-file::/s) {
            $mode = 1;
        } elsif ($line =~ /^ /s) {
            if ($mode eq 1) {
                $summary .= $line;
            }
        } else {
            $mode = 0;
        }
    }
    $fields->{'summary'} = $summary;
}

1;
