<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
   xmlns:xs="http://www.w3.org/2001/XMLSchema"
   xmlns:block="http://example.com/block"
   xmlns:figure="http://example.com/figure"
   xmlns:table="http://example.com/table"
   xmlns:list="http://example.com/list"
   exclude-result-prefixes="xs block figure table list"
   version="3.0">

   <xsl:output indent="yes"/>

   <xsl:use-package name="http://example.com/block"
                    package-version="*"/>
   <xsl:use-package name="http://example.com/figure"
                    package-version="*"/>
   <xsl:use-package name="http://example.com/table"
                    package-version="*"/>
   <xsl:use-package name="http://example.com/list"
                    package-version="*"/>

    <xsl:mode name="main"
          on-no-match="shallow-copy"
          visibility="public"/>

   <!-- entry point -->
   <xsl:template name="xsl:initial-template">
       <xsl:variable name="mode1">
           <xsl:apply-templates mode="main" />
       </xsl:variable>
       <xsl:variable name="mode2">
           <xsl:apply-templates select="$mode1" mode="block"/>
       </xsl:variable>
       <xsl:variable name="mode3">
           <xsl:apply-templates select="$mode2" mode="figure"/>
       </xsl:variable>
       <xsl:variable name="mode4">
           <xsl:apply-templates select="$mode3" mode="table"/>
       </xsl:variable>
       <xsl:variable name="mode5">
           <xsl:apply-templates select="$mode4" mode="list"/>
       </xsl:variable>
       <xsl:sequence select="$mode5"/>
   </xsl:template>

    <xsl:template mode="main" match="container">
        <BUCKET>
            <xsl:apply-templates mode="main"/>
        </BUCKET>
    </xsl:template>

</xsl:stylesheet>
