##---------------------------------------------------------------------------##
##  File:
##	$Id: Config.pm,v 1.7 2002/09/13 07:24:18 ehood Exp $
##  Description:
##	POD at end of file.
##---------------------------------------------------------------------------##
##  Copyright (C) 2002	Earl Hood <earl@earlhood.com>
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##  
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##  
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
##  02111-1307, USA
##---------------------------------------------------------------------------##

package MHArc::Config;

sub load {
    my $self	= { };
    my $mod	= shift;	# Name of module
    my $fname	= shift;	# Filename to read configuration from
    my $class	= ref($mod) || $mod;

    bless $self, $class;
    $self->read_filename($fname);
}

sub read_filename {
  my $self	= shift;
  my $filename	= shift;

  my $fh	= undef;
  my $fh_close	= 0;

  local(*FILE);
  if ($filename eq '-') {
    $fh = \*STDIN;
  } else {
    $filename .= '.dist'  unless (-e $filename);
    open(FILE, $filename) ||
	die qq/ERROR: Unable to open "$filename": $!\n/;
    $fh = \*FILE;
    $fh_close = 1;
  }

  while (defined($line = <$fh>)) {
    next unless $line =~ /\S/;
    next if     $line =~ /^\s*#/;
    chomp $line;
    ($key, $value) = split(/=/, $line, 2);

    if ($value =~ s/^'//) {
      $value =~ s/'$//;
    } else {
      $value =~ s/^"//; $value =~ s/"$//;
      $value = _expand_vars($self, $value);
    }
    $self->{$key} = $value;
  }

  close($fh)  if $fh_close;

  # Check for MHONARC_LIB, and if defined, add to perl's @INC
  if ($self->{'MHONARC_LIB'}) {
    unshift(@INC, $self->{'MHONARC_LIB'});
  }
  $self;
}

sub dump_config {
  my $self = shift;
  my $fh   = shift;

  foreach my $key (sort keys %$self) {
    print $fh $key, '=', $self->{$key}, "\n";
  }
}

sub _expand_vars {
  my $map     = shift;
  my $str     = shift;

  $str =~ s/(^|[^\$])\$(\{[^}]+\}|[\w]+)/$1 . _var_lookup($map, $2);/ge;
  $str;
}

sub _var_lookup {
  my $map     = shift;
  my $key     = shift;
  $key =~ s/[{}]//g;
  defined($map->{$key}) ? $map->{$key} :
      defined($ENV{$key}) ? $ENV{$key} : "";
}

#my $config = MHArc::Config->load('-');
#foreach (sort keys %$config) {
#  print "$_=", $config->{$_}, "\n";
#}

#==========================================================================
1;
__END__

=head1 NAME

MHArc::Config - Load mail archive configuration file

=head1 SYNOPSIS

  $conf = MHArc::Config->load($filename);
  print $conf->{'HTML_DIR'};

=head1 DESCRIPTION

This module will load in the archive configuration file.  The
archive configuration file defines variables in Bourne shell syntax format.

B<NOTE:> Only a subset of the Bourne shell syntax is supported, so do
not get fancy with the file.

The C<load> static method will create a new configuration instance
that is a bless hash reference.  The variables defined in the file
will be the hash keys.

B<NOTE:> If the filename specified does not exist, then the C<load()>
method will check for the filename with a C<.dist> extension.  It
is recommended to not rely on the C<.dist> version since it will
get overwritten on software updates.

=head1 VERSION

C<$Id: Config.pm,v 1.7 2002/09/13 07:24:18 ehood Exp $>

=head1 AUTHOR

Earl Hood, earl@earlhood.com

This module is part of the mharc archiving system and comes with
ABSOLUTELY NO WARRANTY and may be copied only under the terms of
the GNU General Public License, which may be found in the MHArc
distribution.

=cut

