##---------------------------------------------------------------------------##
##  File:
##	$Id: ListDef.pm,v 1.4 2002/09/13 07:24:18 ehood Exp $
##  Description:
##---------------------------------------------------------------------------##
##  Copyright (C) 2002	Earl Hood <earl@earlhood.com>
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##  
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##  
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
##  02111-1307, USA
##---------------------------------------------------------------------------##

package MHArc::ListDef;

sub new {
    my $self	= { };
    my $mod	= shift;	# Name of module
    my $fh	= shift;	# Filehandle to read definitions from
    my $class	= ref($mod) || $mod;

    bless $self, $class;
    $self->load_file($fh);
}

sub load_file {
  my $self = shift;
  my $file = shift;
  my $fh;

  local(*LISTDEF);
  if (!ref($file)) {
    if (!open(LISTDEF, $file)) {
      die qq/ERROR: Unable to open "$file": $!\n/;
    }
    $fh = \*LISTDEF;
      
  } else {
    $fh = $file;
  }

  my $name = undef;
  my($key, $line);

  while (defined($line = <$fh>)) {
    next unless $line =~ /\S/;
    next if     $line =~ /^\s*#/;
    chomp $line;
    ($key, $value) = $line =~ /^([^:]+):\s*(.*)$/;
    $key = lc $key;
    if ($key eq 'name') {
      $value =~ s/\s//g;
      $name = $value;
      next;
    }
    if (!defined($name)) {
      warn qq/Warning: No name defined for '$line'\n/;
      next;
    }

    if (defined($self->{$name}{$key})) {
      push(@{$self->{$name}{$key}}, $value);
    } else {
      $self->{$name}{$key} = [ $value ];
    }
  }

  if (!ref($file)) {
    close($fh);
  }

  $self;
}

1;
__END__

=head1 NAME

MHArc::ListDef - Load mailing lists definition file

=head1 SYNOPSIS

  $def = MHArc::ListDef->new($fh);
  $def = MHArc::ListDef->new($filename);

=head1 DESCRIPTION

This module parses a mailing list definition file for use in the
auto-mail archiving system.

The C<new> method either takes a filehandle reference or a filename
string.

=head1 SEE ALSO

L<mk-procmailrc|mk-procmailrc>

=head1 VERSION

C<$Id: ListDef.pm,v 1.4 2002/09/13 07:24:18 ehood Exp $>

=head1 AUTHOR

Earl Hood, earl@earlhood.com

This module is part of the mharc archiving system and comes with
ABSOLUTELY NO WARRANTY and may be copied only under the terms of
the GNU General Public License, which may be found in the MHArc
distribution.

=cut

