##--------------------------------------------------------------------------##
##  File:
##	$Id: MailUtil.pm,v 1.3 2002/09/13 07:24:18 ehood Exp $
##  Description:
##	POD at end of file.
##--------------------------------------------------------------------------##
##  Copyright (C) 2002	Earl Hood <earl@earlhood.com>
##
##  This program is free software; you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation; either version 2 of the License, or
##  (at your option) any later version.
##  
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##  
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
##  02111-1307, USA
##--------------------------------------------------------------------------##

package MHArc::MailUtil;

use Exporter;
@ISA = qw(Exporter);

@EXPORT_OK = qw(
  &extract_date
);

##--------------------------------------------------------------------------##

BEGIN {
  $Debug = 0;
}

##--------------------------------------------------------------------------##

sub extract_date {
  my $fields      = shift;
  my @dfs         = @_;

  local $_;
  my @date_fields = ( );
  if (!@dfs) {
    @date_fields = ( ['received',0],['delivery-date',0],['date',0] );
  } else {
    foreach (@dfs) {
      s/\s//g;  tr/A-Z/a-z/;
      if (s/\[(\d+)\]//) {
	push(@date_fields, [ $_, $1 ]);
      } else {
	push(@date_fields, [ $_, 0 ]);
      }
    }
  }

  my @date;
  my($field_str, $unix_time, $df, $i);
  foreach (@date_fields) {
    ($df, $i) = @$_;
    if (defined($field_str = $fields->{$df}[$i])) {
      print qq/Debug: $df: $field_str\n/  if $Debug;
      if ($df eq 'received') {
	my @ra = split(/;/, $field_str);
	$field_str = pop(@ra);
      }
      @date = mhonarc::parse_date($field_str);
      if (scalar(@date)) {
	print qq/Debug: \@date=/, join('|',@date), qq/\n/  if $Debug;
	$unix_time = mhonarc::get_time_from_date(@date[1..$#date]);
	last;
      }
    }
  }
  if (!defined($unix_time)) {
    print qq/Debug: Unable to parse date, using current time\n/  if $Debug;
    $unix_time = time;
  }
  $unix_time;
}

##--------------------------------------------------------------------------##
1;
__END__

=head1 NAME

MHArc::MailUtil - General mail-related utilities for mail archiving system.

=head1 SYNOPSIS

  use MHArc::MailUtil;

=head1 DESCRIPTION

This module contains a collection of mail-related utility routines.

=head1 VARIABLES

The following module variables can be set to affect the behavior
of the utility routines:

=over

=item C<$Debug>

If set to a true value, routines will print out debuging information.

=back

=head1 ROUTINES

By default, no routines are exported into the calling namespace.
Routines in this module can be imported by explicitly listing the
routines to import in the C<use> declaration:

  use MHArc::MailUtil qw( extract_date );

The following routines are availale:

=over

=item C<extract_date($fields, I<@date_fields>)>

Extract the date from message header fields represented by C<$fields>.
Any additional arguments are treated as message fields names (which
should be lowercase names) to examine to find the date.  If no fields
names are specified, than the following fields are checked in order:
C<Received>, C<Delivery-Date>, and C<Date>.

The return value of this function is the date of the message in
Unix time format: the same as what is returned by Perl's
builtin C<time> function.

=back

=head1 DEPENDENCIES

Functions in this module assume that the MHonArc libraries have
already been loaded.

=head1 VERSION

C<$Id: MailUtil.pm,v 1.3 2002/09/13 07:24:18 ehood Exp $>

=head1 AUTHOR

Earl Hood, earl@earlhood.com

This module is part of the mharc archiving system and comes with
ABSOLUTELY NO WARRANTY and may be copied only under the terms of
the GNU General Public License, which may be found in the mharc
distribution.

=cut

